#version 150

// Combines the glowing particles and the normal image buffer.
// Adapted from https://learnopengl.com/Advanced-Lighting/Bloom

uniform sampler2D DiffuseSampler;
uniform sampler2D VerticalParticles;
uniform sampler2D RedParticles;

uniform float Time;

in vec2 texCoord;
in vec2 oneTexel;

uniform float InSize;


uniform float gamma = 0.1;
uniform float exposure = 1.0;

out vec4 fragColor;


void main() {
    vec3 glowColor = texture(VerticalParticles, texCoord).rgb;
    vec3 normalColor = texture(DiffuseSampler, texCoord).rgb;

    normalColor += glowColor;

    vec3 result = vec3(1.0) - exp(-normalColor * exposure);
    result = pow(result, vec3(1.0 / gamma));

    fragColor = vec4(normalColor, 1.0);
}